<?php
/*-------------------------------------
	ȨУţƿƼ޹˾4006481890
	汾1.0
	ڣ//last modified on 2013-04-19 
-------------------------------------*/
class member
{
	private $db;
	private $m_table;
	private $invitecode_table;
	private $signin_table;
	private $auth_table;
	private $m_person;
	private $m_company;
	private $mail_content;
	private $membergrade_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->m_table=LA_PRE.'member';
		$this->invitecode_table=LA_PRE.'invitecode';
		$this->signin_table=LA_PRE.'signin';
		$this->auth_table=LA_PRE.'auth';
		$this->m_person=LA_PRE.'m_person';
		$this->m_company=LA_PRE.'m_company';
		$this->mail_content=LA_PRE.'mail_content';
		$this->membergrade_table=LA_PRE.'member_grade';
	}

	function recharge($userid,$amount=0,$point=0)
	{
		global $stringcacheobj;
		$userid=intval($userid);
		$amount=floatval($amount);
		$point=intval($point);
		
		$modelid=$this->getmodelid($userid);

		if($modelid==1)
		{
			$this->db->query("UPDATE `$this->m_person` SET `$this->m_person`.`amount`=`$this->m_person`.`amount`+$amount,`$this->m_person`.`point`=`$this->m_person`.`point`+$point WHERE `$this->m_person`.`id`=$userid");
		}
		else if($modelid==3)
		{
			$this->db->query("UPDATE `$this->m_company` SET `$this->m_company`.`amount`=`$this->m_company`.`amount`+$amount,`$this->m_company`.`point`=`$this->m_company`.`point`+$point WHERE `$this->m_company`.`id`=$userid");
		}
		$stringcacheobj->rm('member-userpoint-'.$userid);
		$stringcacheobj->rm('member-useramount-'.$userid);
		return true;
	}

	function getusername($id)
	{
		return $this->get($id,'username');
	}

	function getuserid($username)
	{
		$username=trim($username);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`username`='$username'");
		return $r?$r['id']:0;
	}

	function getuseridbyemail($email)
	{
		$email=trim($email);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`email`='$email'");
		return $r?$r['id']:0;
	}

	function getuseridbysinaauth($sinaauth)
	{
		$sinaauth=trim($sinaauth);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`sinaauth`='$sinaauth'");
		return $r?$r['id']:0;
	}

	function getuseridbyqzauth($qqauth)
	{
		$qqauth=trim($qqauth);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`qqauth`='$qqauth'");
		return $r?$r['id']:0;
	}

	function getuserpwdbyid($id)
	{
		$id=intval($id);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`id`=$id");
		return $r?$r['password']:'';
	}

	function getuserpwd($username)
	{
		$username=trim($username);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`username`='$username'");
		return $r?$r['password']:'';
	}
	
	function getmodelid($id)
	{
		$id=intval($id);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`id`=$id");
		return $r?$r['modelid']:0;
	}
	
	function set($id,$info=array())
	{
		global $dataobj,$modelobj;
		$userid=intval($id);
		$modelid=$this->getmodelid($userid);

		if($modelid==1)
		{
			$dataobj->setmodel(array(1,2));
			$info=$dataobj->filter($info);
			$this->db->update($this->m_table,$info,'id='.$userid);
			$this->db->update($this->m_person,$info,'id='.$userid);
			$hash_table=get_hash_table($this->m_person.'_data',$userid,$modelobj->subformcount(2));
			return $this->db->update($hash_table,$info,'mid='.$userid);
		}
		else if($modelid==3)
		{
			$dataobj->setmodel(array(3,4));
			$info=$dataobj->filter($info);
			$this->db->update($this->m_table,$info,'id='.$userid);
			$this->db->update($this->m_company,$info,'id='.$userid);
			$hash_table=get_hash_table($this->m_company.'_data',$userid,$modelobj->subformcount(4));
			return $this->db->update($hash_table,$info,'mid='.$userid);
		}

		return false;
	}

	function register($info=array())
	{
		global $modelobj;

		$info['mid']=$info['id']=$userid=$this->db->insert($this->m_table,$info,true);
		
		
		if($info['modelid']==1)
		{
			$this->db->insert($this->m_person,$info,true);
			$hash_table=get_hash_table($this->m_person.'_data',$userid,$modelobj->subformcount(2));
			return $this->db->insert($hash_table,$info,true);
		}

		if($info['modelid']==3)
		{
			$this->db->insert($this->m_company,$info,true);
			$hash_table=get_hash_table($this->m_company.'_data',$userid,$modelobj->subformcount(4));
			return $this->db->insert($hash_table,$info,true);
		}

		return false;
	}

	function registercheck($unqqsina=1)
	{
		global $MEM,$LA;
		$captcha_open=explode(",",$LA['captcha_open']);
		$captquetion_open=explode(",",$LA['captquetion_open']);
		$site_close_time=explode(",",$LA['site_close_time']);
		$access_city=explode("|",$LA['access_city']);
		$forbidden_city=explode("|",$LA['forbidden_city']);
		
		if($MEM['settings']['open_type']==2)
		{
			showjsmsg($MEM['settings']['open_close_reason']);
		}

		if($MEM['settings']['close_time_forbidden']==1 && !in_array(date('H'),$site_close_time) && $site_close_time)
		{
			showjsmsg('÷ʱιرעᣡ');
		}

		if($MEM['settings']['access_city_forbidden']==1 && !searcharray(ip2area(IP),$access_city) && $access_city)
		{
			showjsmsg('ڵ '.ip2area(IP).' עᣡ');
		}

		if($MEM['settings']['forbidden_city_forbidden']==1 && searcharray(ip2area(IP),$forbidden_city) && $forbidden_city)
		{
			showjsmsg('ڵ '.ip2area(IP).' עᣡ');
		}
		
		if($unqqsina)
		{
			if(in_array(1,$captcha_open) && $_POST['inputcheckcode']!=$_SESSION['captcha'])
			{
				showjsmsg('֤벻ȷ');
			}

			if(in_array(1,$captquetion_open) && $_POST['inputcheckanswer']!=$LA['captquetion_answer'])
			{
				showjsmsg('֤ش벻ȷ');
			}
		}

		return true;
	}

	function getbase($id,$f='*')
	{
		$id=intval($id);
		$r=$this->db->fetch_one("SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`id`=$id");
		return $f=='*'?$r:$r[$f];
	}

	function get($id,$f='*',$modelid=0)
	{
		$id=intval($id);
		
		if($modelid==0)
		{
			$r=$this->personinfo($id);
			if(!$r)
			{
				$r=$this->companyinfo($id);
				$r['modelid']=3;
			}
			else
			{
				$r['modelid']=1;
			}
		}
		else if($modelid==1)
		{
			$r=$this->personinfo($id);
			$r['modelid']=1;
		}
		else if($modelid==3)
		{
			$r=$this->companyinfo($id);
			$r['modelid']=3;
		}

		if(!$r)
		{
			return $f=='*'?array():'';
		}

		return $f=='*'?$r:$r[$f];
	}
	
	function isexistsbyemail($email='',$password='')
	{
		$email=addslashes(trim($email));
		$password=md5(trim($password));

		$sql="SELECT * FROM `$this->m_table` WHERE `$this->m_table`.`username`='$username' AND `$this->m_table`.`password`='$password'";

		return $this->db->fetch_one($sql);
	}
	
	function checkmember($username='',$email='')
	{
		global $sitelang;
		$username=addslashes(trim($username));
		$email=addslashes(trim($email));

		$usql="SELECT `$this->m_table`.`id` FROM `$this->m_table` WHERE `$this->m_table`.`username`='$username'";
		$esql="SELECT `$this->m_table`.`id` FROM `$this->m_table` WHERE `$this->m_table`.`email`='$email'";

		if($username && $this->db->fetch_one($usql))
		{
			showjsmsg($sitelang['exists-username']);
		}

		if($email && $this->db->fetch_one($esql))
		{
			showjsmsg($sitelang['exists-email']);
		}

		return true;
	}
	/******˻Ա*****/
	function admin_personlist($gradeid=0,$username='')
	{
		global $page,$_siteid,$siteidobj;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$gradeid?' AND gradeid='.intval($gradeid):'';
		$where.=$username?' AND username LIKE "%'.htmlspecialchars($username).'%"':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='gradeid ASC , id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=10;
		$result=$datalist->getlist($this->m_person,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function admin_personadd($info)
	{
		global $modelobj,$settings,$dataobj;

		$dataobj->setmodel(array(1,2));
		$info=$dataobj->filter($info);
		$info['modelid']=1;
		$info['point']=intval($settings['defaultpoint']);
		$info['amount']=floatval($settings['defaultamount']);
		$info['regtime']=$info['logintime']=TIME;
		$info['regip']=$info['loginip']=IP;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['expire']=TIME+intval($settings['defaultexpire'])*24*3600;
		$userid=$this->db->insert($this->m_table,$info,true);
		$info['id']=$info['mid']=$userid;
		$this->db->insert($this->m_person,$info,true);
		$hash_table=get_hash_table($this->m_person.'_data',$info['mid'],$modelobj->subformcount(2));
		$this->db->insert($hash_table,$info,true);
		return $userid;
	}

	function admin_personedit($id,$info)
	{
		global $modelobj,$settings,$dataobj,$_siteid,$siteidobj;
		$info['mid']=$id=intval($id);
		$minfo=$this->personinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$dataobj->setmodel(array(1,2));
		$info=$dataobj->filter($info);
		$this->db->update($this->m_table,$info,'id='.$id);
		$this->db->update($this->m_person,$info,'id='.$id);
		$hash_table=get_hash_table($this->m_person.'_data',$info['mid'],$modelobj->subformcount(2));
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function admin_person_upgrade($id,$gradeid=1,$expire=0)
	{
		global $_siteid,$siteidobj;

		$ids=array_map('intval',explode(',',$id));
		foreach($ids as $id)
		{
			$info=array();

			$minfo=$this->personinfo($id);
			if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
			{
				return false;
			}
			
			$info['gradeid']=intval($gradeid);
			$info['expire']=intval($expire)*24*3600+$minfo['expire'];
			$this->db->update($this->m_person,$info,'id='.$id);
		}
		return true;
	}

	function admin_persondelete($id)
	{
		global $modelobj,$attchobj,$_siteid,$siteidobj;

		$id=intval($id);
		$minfo=$this->personinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$this->db->mysql_delete($this->m_table,$id);
		$this->db->mysql_delete($this->m_person,$id);
		$hash_table=get_hash_table($this->m_person.'_data',$id,$modelobj->subformcount(2));
		
		if($hash_table && in_array($hash_table,$this->db->get_tables()))
		{
			$this->db->mysql_delete($hash_table,$id,'mid');
		}
		
		$attchobj->attchment_delete($id,1);
		return true;
	}

	function personinfo($id)
	{
		global $modelobj;
		$id=intval($id);
		$hash_table=get_hash_table($this->m_person.'_data',$id,$modelobj->subformcount(2));
		return $this->db->fetch_one("SELECT * FROM `$this->m_person` a LEFT JOIN `$hash_table` b ON a.id=b.mid WHERE a.`id`=$id");
	}

	function personcount($gradeid=0)
	{
		global $_siteid,$siteidobj;
		$gradeid=intval($gradeid);

		if($gradeid)
		{
			if($_siteid)
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_person` WHERE `$this->m_person`.`siteid` IN(".implode(',',$siteidobj->getchildid($_siteid)).") AND `$this->m_person`.`gradeid`=".intval($gradeid);
			}
			else
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_person` WHERE `$this->m_person`.`gradeid`=".intval($gradeid);
			}
		}
		else
		{
			if($_siteid)
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_person` WHERE `$this->m_person`.`siteid` IN (".implode(',',$siteidobj->getchildid($_siteid)).")";
			}
			else
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_person` WHERE 1";
			}
		}

		return get_cache_counts($sql);
	}

	function person_sendmessage($id,$info)
	{
		global $modelobj,$settings,$dataobj,$_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->personinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$dataobj->setmodel(array(18,19));
		$info=$dataobj->filter($info);
		$info['siteid']=intval($_SESSION['siteid']);
		$info['datetime']=TIME;
		$info['senduserid']=0;
		$info['touserid']=intval($id);

		$info['mid']=$this->db->insert($this->mail_content,$info);
		$hash_table=get_hash_table($this->mail_content.'_data',$info['mid'],$modelobj->subformcount(19));
		return $this->db->insert($hash_table,$info,true);
	}

	function person_charge($id,$info)
	{
		global $_siteid,$payobj,$siteidobj;
		$id=intval($id);
		$minfo=$this->personinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$_point=intval($info['point']);
		$_amount=floatval($info['amount']);

		$info['point']=max(0,intval($info['point'])+$minfo['point']);
		$info['amount']=max(0.0,floatval($info['amount'])+$minfo['amount']);
		if($_point)
		{
			$log=array();
			$log['userid']=$id;
			$log['inputtime']=TIME;
			$log['ichange']=$_point;
			$log['desc']='Աֵ̨';
			$log['current']=$info['point'];
			$log['type']='point';
			$log['siteid']=$_SESSION['siteid'];
			$payobj->set_cashlog($id,$log);
		}

		if($_amount)
		{
			$log=array();
			$log['userid']=$id;
			$log['inputtime']=TIME;
			$log['ichange']=$_amount;
			$log['desc']='Աֵ̨';
			$log['current']=$info['amount'];
			$log['type']='amount';
			$log['siteid']=$_SESSION['siteid'];
			$payobj->set_cashlog($id,$log);
		}
		return $this->db->update($this->m_person,$info,'id='.$id);
	}

	/******ҵԱ*****/
	function admin_companylist($gradeid=0,$username='')
	{
		global $page,$_siteid,$siteidobj;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$gradeid?' AND gradeid='.intval($gradeid):'';
		$where.=$username?' AND username LIKE "%'.htmlspecialchars($username).'%"':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='gradeid ASC , id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=10;
		$result=$datalist->getlist($this->m_company,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function admin_companyadd($info)
	{
		global $modelobj,$settings,$dataobj;

		$dataobj->setmodel(array(3,4));
		$info=$dataobj->filter($info);
		$info['modelid']=3;
		$info['point']=intval($settings['defaultpoint']);
		$info['amount']=floatval($settings['defaultamount']);
		$info['regtime']=$info['logintime']=TIME;
		$info['regip']=$info['loginip']=IP;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['expire']=TIME+intval($settings['defaultexpire'])*24*3600;
		$userid=$this->db->insert($this->m_table,$info);
		$info['id']=$info['mid']=$userid;
		$this->db->insert($this->m_company,$info,true);
		$hash_table=get_hash_table($this->m_company.'_data',$info['mid'],$modelobj->subformcount(4));
		$this->db->insert($hash_table,$info,true);
		return $userid;
	}

	function admin_companyedit($id,$info)
	{
		global $modelobj,$settings,$dataobj,$_siteid;
		$info['mid']=$id=intval($id);
		$minfo=$this->companyinfo($id);
		if(!$minfo || ($_siteid && $_siteid!=$minfo['siteid']))
		{
			return false;
		}

		$dataobj->setmodel(array(3,4));
		$info=$dataobj->filter($info);
		$this->db->update($this->m_table,$info,'id='.$id);
		$this->db->update($this->m_company,$info,'id='.$id);
		$hash_table=get_hash_table($this->m_company.'_data',$info['mid'],$modelobj->subformcount(4));
		return $this->db->update($hash_table,$info,'mid='.$id);
	}

	function admin_company_upgrade($id,$gradeid=1,$expire=0)
	{
		global $_siteid,$siteidobj;

		$ids=array_map('intval',explode(',',$id));
		foreach($ids as $id)
		{
			$info=array();

			$minfo=$this->companyinfo($id);
			if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
			{
				return false;
			}
			
			$info['gradeid']=intval($gradeid);
			$info['expire']=intval($expire)*24*3600+$minfo['expire'];
			$this->db->update($this->m_company,$info,'id='.$id);
		}
		return true;
	}

	function admin_companydelete($id)
	{
		global $modelobj,$attchobj,$_siteid,$siteidobj;

		$id=intval($id);
		$minfo=$this->companyinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$this->db->mysql_delete($this->m_table,$id);
		$this->db->mysql_delete($this->m_company,$id);
		$hash_table=get_hash_table($this->m_company.'_data',$id,$modelobj->subformcount(4));
		
		if($hash_table && in_array($hash_table,$this->db->get_tables()))
		{
			$this->db->mysql_delete($hash_table,$id,'mid');
		}
		
		$attchobj->attchment_delete($id,3);
		return true;
	}

	function companyinfo($id)
	{
		global $modelobj;
		$id=intval($id);
		$hash_table=get_hash_table($this->m_company.'_data',$id,$modelobj->subformcount(4));
		return $this->db->fetch_one("SELECT * FROM `$this->m_company` a LEFT JOIN `$hash_table` b ON a.id=b.mid WHERE a.`id`=$id");
	}

	function companycount($gradeid=0)
	{
		global $_siteid,$siteidobj;
		$gradeid=intval($gradeid);

		if($gradeid)
		{
			if($_siteid)
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_company` WHERE `$this->m_company`.`siteid` IN(".implode(',',$siteidobj->getchildid($_siteid)).") AND `$this->m_company`.`gradeid`=".intval($gradeid);
			}
			else
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_company` WHERE `$this->m_company`.`gradeid`=".intval($gradeid);
			}
		}
		else
		{
			if($_siteid)
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_company` WHERE `$this->m_company`.`siteid` IN(".implode(',',$siteidobj->getchildid($_siteid)).")";
			}
			else
			{
				$sql="SELECT COUNT(*) AS count FROM `$this->m_company` WHERE 1";
			}
		}

		return get_cache_counts($sql);
	}

function company_sendmessage($id,$info)
	{
		global $modelobj,$settings,$dataobj,$_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->companyinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$dataobj->setmodel(array(18,19));
		$info=$dataobj->filter($info);
		$info['siteid']=intval($_SESSION['siteid']);
		$info['datetime']=TIME;
		$info['senduserid']=0;
		$info['touserid']=intval($id);

		$info['mid']=$this->db->insert($this->mail_content,$info);
		$hash_table=get_hash_table($this->mail_content.'_data',$info['mid'],$modelobj->subformcount(19));
		return $this->db->insert($hash_table,$info,true);
	}

	function company_charge($id,$info)
	{
		global $_siteid,$payobj,$siteidobj;
		$id=intval($id);
		$minfo=$this->companyinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$_point=intval($info['point']);
		$_amount=floatval($info['amount']);

		$info['point']=max(0,intval($info['point'])+$minfo['point']);
		$info['amount']=max(0.0,floatval($info['amount'])+$minfo['amount']);
		if($_point)
		{
			$log=array();
			$log['userid']=$id;
			$log['inputtime']=TIME;
			$log['ichange']=$_point;
			$log['desc']='Աֵ̨';
			$log['current']=$info['point'];
			$log['type']='point';
			$log['siteid']=$_SESSION['siteid'];
			$payobj->set_cashlog($id,$log);
		}

		if($_amount)
		{
			$log=array();
			$log['userid']=$id;
			$log['inputtime']=TIME;
			$log['ichange']=$_amount;
			$log['desc']='Աֵ̨';
			$log['current']=$info['amount'];
			$log['type']='amount';
			$log['siteid']=$_SESSION['siteid'];
			$payobj->set_cashlog($id,$log);
		}

		return $this->db->update($this->m_company,$info,'id='.$id);
	}

	/***** Աȼ ****/
	function gradeinfo($id,$f='*')
	{
		$id=intval($id);
		$r=$this->db->fetch_one("SELECT * FROM `$this->membergrade_table` WHERE `$this->membergrade_table`.`id`=$id");
		return $f=='*'?$r:$r[$f];
	}

	function gradelist()
	{
		global $page,$_siteid,$siteidobj;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=10;
		$result=$datalist->getlist($this->membergrade_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function gradeedit($id,$info)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->gradeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		return $this->db->update($this->membergrade_table,$info,'id='.$id);
	}

	/***** վ ****/
	function messageinfo($id,$f='*')
	{
		global $modelobj;
		$id=intval($id);
		$hash_table=get_hash_table($this->mail_content.'_data',$id,$modelobj->subformcount(19));
		$r=$this->db->fetch_one("SELECT * FROM `$this->mail_content` a LEFT JOIN `$hash_table` b ON a.id=b.mid WHERE a.`id`=$id");
		return $f=='*'?$r:$r[$f];
	}

	function messagedelete($id)
	{
		global $modelobj,$_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->gradeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$hash_table=get_hash_table($this->mail_content.'_data',$id,$modelobj->subformcount(19));
		$this->db->mysql_delete($this->mail_content,$id);
		$this->db->mysql_delete($hash_table,$id,'mid');
		return true;
	}
	
	function inboxsetdelete($ids,$userid)
	{
		$ids=array_map('intval',$ids);
		$userid=intval($userid);

		foreach($ids as $id)
		{
			$minfo=$this->messageinfo($id);
			if($minfo['touserid']==$userid && $userid)
			{
				$this->db->update($this->mail_content,array('isdeleted'=>1),'id='.$id);
			}
		}

		return true;
	}

	function inboxsetread($ids,$userid)
	{
		$ids=is_array($ids)?$ids:array($ids);
		$ids=array_map('intval',$ids);
		$userid=intval($userid);

		foreach($ids as $id)
		{
			$minfo=$this->messageinfo($id);
			if($minfo['touserid']==$userid && $userid)
			{
				$this->db->update($this->mail_content,array('isreaded'=>1),'id='.$id);
			}
		}

		return true;
	}

	function outboxsetdelete($ids,$userid)
	{
		$ids=array_map('intval',$ids);
		$userid=intval($userid);

		foreach($ids as $id)
		{
			$minfo=$this->messageinfo($id);
			if($minfo['senduserid']==$userid && $userid)
			{
				$this->db->update($this->mail_content,array('isdeleted'=>1),'id='.$id);
			}
		}

		return true;
	}

	function outboxsetread($ids,$userid)
	{
		$ids=array_map('intval',$ids);
		$userid=intval($userid);

		foreach($ids as $id)
		{
			$minfo=$this->messageinfo($id);
			if($minfo['senduserid']==$userid && $userid)
			{
				$this->db->update($this->mail_content,array('isreaded'=>1),'id='.$id);
			}
		}

		return true;
	}

	function messagelist()
	{
		global $page,$_siteid,$siteidobj;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=10;
		$result=$datalist->getlist($this->mail_content,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function membermessage($userid,$inbox=1)
	{
		global $page;
		$userid=intval($userid);
		$inbox=intval($inbox);
		if($inbox==1)
		{
			$where='(touserid='.$userid.' OR touserid=0 OR issystem=1) AND isdeleted=0';
		}
		else
		{
			$where='senduserid='.$userid.' AND isdeleted=0';
		}
		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=5;
		$result=$datalist->getlist($this->mail_content,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function sendmessage($info)
	{
		global $modelobj,$settings,$dataobj,$_siteid;

		$dataobj->setmodel(array(18,19));
		$info=$dataobj->filter($info);
		$info['siteid']=intval($_SESSION['siteid']);
		$info['datetime']=TIME;
		$info['senduserid']=0;
		$info['touserid']=0;
		$info['issystem']=1;
		$info['mid']=$this->db->insert($this->mail_content,$info);
		$hash_table=get_hash_table($this->mail_content.'_data',$info['mid'],$modelobj->subformcount(19));
		return $this->db->insert($hash_table,$info,true);
	}

	function usersendmsg($info,$touser)
	{
		global $modelobj,$settings,$dataobj,$_userid;
		
		if(!preg_match('/^[\x80-\xff_a-zA-Z0-9]{1,64}$/i',$touser))
		{
			return false;
		}

		$info['touserid']=$this->getuserid($touser);

		if(!$info['touserid'] || $info['touserid']==$_userid)
		{
			return false;
		}
		$dataobj->setmodel(array(18,19));
		$info=$dataobj->filter($info);
		$info['siteid']=intval($_SESSION['siteid']);
		$info['datetime']=TIME;
		$info['senduserid']=$_userid;
		$info['issystem']=0;
		$info['mid']=$this->db->insert($this->mail_content,$info);
		$hash_table=get_hash_table($this->mail_content.'_data',$info['mid'],$modelobj->subformcount(19));
		return $this->db->insert($hash_table,$info,true);
	}

	function messagecount($userid=0)
	{
		$userid=intval($userid);
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->mail_content` WHERE (`$this->mail_content`.`touserid`=$userid OR `$this->mail_content`.`issystem`=1) AND `$this->mail_content`.`isreaded`=0 AND `$this->mail_content`.`isdeleted`=0");
	}

	/*
		Ա֤
	*/

	function authlist($isemail=1,$isidcard=1,$iscertificate=1)
	{
		global $page,$_siteid,$siteidobj;
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$isemail?'':' AND isemail=0';
		$where.=$isidcard?'':' AND isidcard=0';
		$where.=$iscertificate?'':' AND iscertificate=0';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='isemail ASC,iscertificate ASC,isidcard ASC,id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=10;
		$result=$datalist->getlist($this->auth_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function authinfo($id)
	{
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`id`=$id");
	}
	
	function auth_delete($id)
	{
		global $settings,$_siteid,$siteidobj;
		
		$ainfo=$this->authinfo($id);
		$minfo=$this->get($ainfo['userid']);

		if(!$ainfo || !$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		return $this->db->mysql_delete($this->auth_table,intval($id));
	}

	function up_email_auth($userid,$email)
	{
		if(!preg_match('/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/i',$email))
		{
			return false;
		}

		$userid=intval($userid);

		$r=$this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid");
		$info['userid']=$userid;
		if($r)
		{
			$this->db->update($this->auth_table,array('email'=>$email),'userid='.$userid);
		}
		else
		{
			$this->db->insert($this->auth_table,array('isemail'=>0,'email'=>$email,'userid'=>$userid),true);
		}

		return true;
	}

	function up_mobile_auth($userid,$mobile)
	{
		if(!preg_match('/^[01][0-9_]{10,14}$/i',$mobile))
		{
			return false;
		}

		$userid=intval($userid);

		$r=$this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid");
		$info['userid']=$userid;
		if($r)
		{
			$this->db->update($this->auth_table,array('mobile'=>$mobile),'userid='.$userid);
		}
		else
		{
			$this->db->insert($this->auth_table,array('ismobile'=>0,'mobile'=>$mobile,'userid'=>$userid),true);
		}

		return true;
	}

	function up_certificate_auth($userid,$info)
	{
		if(!is_image($info['certificate']))
		{
			return false;
		}

		$userid=intval($userid);

		$r=$this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid");
		$info['userid']=$userid;
		if($r)
		{
			$this->db->update($this->auth_table,$info,'userid='.$userid);
		}
		else
		{
			$this->db->insert($this->auth_table,$info,true);
		}

		return true;
	}

	function up_idcard_auth($userid,$info)
	{
		$info=array_map('htmlspecialchars',$info);
		if(!is_image($info['idcard']))
		{
			return false;
		}

		$userid=intval($userid);

		$r=$this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid");
		$info['userid']=$userid;
		if($r)
		{
			$this->db->update($this->auth_table,$info,'userid='.$userid);
		}
		else
		{
			$this->db->insert($this->auth_table,array('isidcard'=>0,$info,'userid'=>$userid),true);
		}

		return true;
	}

	function isemail_auth($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid AND `$this->auth_table`.`isemail`=1");
	}

	function ismobile_auth($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid AND `$this->auth_table`.`ismobile`=1");
	}

	function iscertificate_auth($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid AND `$this->auth_table`.`iscertificate`=1");
	}

	function iscertificate_uploaded($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid AND `$this->auth_table`.`certno`!=''");
	}

	function isidcard_auth($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid AND `$this->auth_table`.`isidcard`=1");
	}

	function isidcard_uploaded($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->auth_table` WHERE `$this->auth_table`.`userid`=$userid AND `$this->auth_table`.`idcardno`!=''");
	}

	function set_email_auth($userid)
	{
		global $settings,$payobj;
		$userid=intval($userid);
		if($this->isemail_auth($userid))
		{
			return false;
		}
		$this->db->update($this->auth_table,array('isemail'=>1),'userid='.$userid);

		$r=$this->personinfo($userid);
		if(!$r)
		{
			$r=$this->companyinfo($userid);
			$this->db->update($this->m_company,array('point'=>intval($r['point']+$settings['emailauthpoint'])),'id='.$userid);
		}
		else
		{
			$this->db->update($this->m_person,array('point'=>intval($r['point']+$settings['emailauthpoint'])),'id='.$userid);
		}

		$_point=intval($settings['emailauthpoint']);

		if($_point)
		{
			$log=array();
			$log['userid']=$userid;
			$log['inputtime']=TIME;
			$log['ichange']=$_point;
			$log['desc']='û֤';
			$log['current']=intval($r['point']+$settings['emailauthpoint']);
			$log['type']='point';
			$log['siteid']=$_SESSION['siteid'];
			$payobj->set_cashlog($userid,$log);
		}

		return true;
	}

	function setemailauth($status,$userid)
	{
		global $settings,$_siteid,$payobj,$siteidobj;
		$minfo=$this->get($userid);
		
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$userid=intval($userid);
		$status=intval($status);
		if(($status && $this->isemail_auth($userid)) || (!$status && !$this->isemail_auth($userid)))
		{
			return false;
		}
	
		if($status)
		{
			if($status>0)
			{
				$this->db->update($this->auth_table,array('isemail'=>1),'userid='.$userid);

				if($minfo['modelid']==1)
				{
					$this->db->update($this->m_person,array('point'=>intval($minfo['point']+$settings['emailauthpoint'])),'id='.$userid);
				}
				else
				{
					$this->db->update($this->m_company,array('point'=>intval($minfo['point']+$settings['emailauthpoint'])),'id='.$userid);
				}

				$_point=intval($settings['emailauthpoint']);

				if($_point)
				{
					$log=array();
					$log['userid']=$userid;
					$log['inputtime']=TIME;
					$log['ichange']=$_point;
					$log['desc']='û֤ͨ';
					$log['current']=intval($minfo['point']+$settings['emailauthpoint']);
					$log['type']='point';
					$log['siteid']=$_SESSION['siteid'];
					$payobj->set_cashlog($userid,$log);
				}
			}
			else
			{
				$this->db->update($this->auth_table,array('isemail'=>0,'email'=>''),'userid='.$userid);
			}
		}
		else
		{
			$this->db->update($this->auth_table,array('isemail'=>0,'email'=>''),'userid='.$userid);
			if($minfo['modelid']==1)
			{
				$this->db->update($this->m_person,array('point'=>max(0,intval($minfo['point']-$settings['emailauthpoint']))),'id='.$userid);
			}
			else
			{
				$this->db->update($this->m_company,array('point'=>max(0,intval($minfo['point']-$settings['emailauthpoint']))),'id='.$userid);
			}

			$_point=intval($settings['emailauthpoint']);

			if($_point)
			{
				$log=array();
				$log['userid']=$userid;
				$log['inputtime']=TIME;
				$log['ichange']='-'.$_point;
				$log['desc']='ûȡ֤';
				$log['current']=max(0,intval($minfo['point']-$settings['emailauthpoint']));
				$log['type']='point';
				$log['siteid']=$_SESSION['siteid'];
				$payobj->set_cashlog($userid,$log);
			}
		}
		$site_name=$LA['sitename'];
		$site_url=$LA['siteurl'];
		$desc='ύ֤'.($status>0?'':'δ').'̨ͨˡ<br />ͨע鿴ϸϢ<br />';
		$username=userinfo($_userid,'username');

		$emailbody=stripslashes(file_get_contents(SYSTEM_ROOT.'template/email/email.html'));
		$emailbody=str_replace('{$site_name}',$site_name,$emailbody);
		$emailbody=str_replace('{$site_url}',$site_url,$emailbody);
		$emailbody=str_replace('{$username}',$minfo['username'],$emailbody);
		$emailbody=str_replace('{$email}',$minfo['email'],$emailbody);
		$emailbody=str_replace('{$desc}',$desc,$emailbody);
		$emailbody=str_replace('{$url}',$LA['siteurl'].'member/index.php?file=account&action=certificate',$emailbody);
		require_once SYSTEM_ROOT.'include/email.class.php';
		$emailobj=new email();
		$emailobj->set($LA['mail_server'], $LA['mail_port'], $LA['mail_user'], $LA['mail_pwd'], $LA['mail_type']);
		$emailobj->send($minfo['email'], $LA['sitename'].'- ֤', $emailbody, $LA['mail_user']);
		return true;
	}

	function setidcardauth($status,$userid)
	{
		global $settings,$_siteid,$payobj,$siteidobj;
		$minfo=$this->get($userid);
		
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$userid=intval($userid);
		$status=intval($status);
		if(($status && $this->isidcard_auth($userid)) || (!$status && !$this->isidcard_auth($userid)))
		{
			return false;
		}
	
		if($status)
		{
			if($status>0)
			{
				$this->db->update($this->auth_table,array('isidcard'=>1),'userid='.$userid);
				if($minfo['modelid']==1)
				{
					$this->db->update($this->m_person,array('point'=>intval($minfo['point']+$settings['idcardauthpoint'])),'id='.$userid);
				}
				else
				{
					$this->db->update($this->m_company,array('point'=>intval($minfo['point']+$settings['idcardauthpoint'])),'id='.$userid);
				}

				$_point=intval($settings['idcardauthpoint']);

				if($_point)
				{
					$log=array();
					$log['userid']=$userid;
					$log['inputtime']=TIME;
					$log['ichange']=$_point;
					$log['desc']='û֤ͨ';
					$log['current']=intval($minfo['point']+$settings['idcardauthpoint']);
					$log['type']='point';
					$log['siteid']=$_SESSION['siteid'];
					$payobj->set_cashlog($userid,$log);
				}
			}
			else
			{
				$this->db->update($this->auth_table,array('isidcard'=>0,'idcard'=>'','idcardno'=>'','realname'=>''),'userid='.$userid);
			}
		}
		else
		{
			$this->db->update($this->auth_table,array('isidcard'=>0,'idcard'=>'','idcardno'=>'','realname'=>''),'userid='.$userid);
			if($minfo['modelid']==1)
			{
				$this->db->update($this->m_person,array('point'=>max(0,intval($minfo['point']-$settings['idcardauthpoint']))),'id='.$userid);
			}
			else
			{
				$this->db->update($this->m_company,array('point'=>max(0,intval($minfo['point']-$settings['idcardauthpoint']))),'id='.$userid);
			}

			$_point=intval($settings['idcardauthpoint']);

			if($_point)
			{
				$log=array();
				$log['userid']=$userid;
				$log['inputtime']=TIME;
				$log['ichange']='-'.$_point;
				$log['desc']='ûȡ֤';
				$log['current']=max(0,intval($minfo['point']-$settings['idcardauthpoint']));
				$log['type']='point';
				$log['siteid']=$_SESSION['siteid'];
				$payobj->set_cashlog($userid,$log);
			}
		}
		$site_name=$LA['sitename'];
		$site_url=$LA['siteurl'];
		$desc='ύ֤'.($status>0?'':'δ').'̨ͨˡ<br />ͨע鿴ϸϢ<br />';
		$username=userinfo($_userid,'username');

		$emailbody=stripslashes(file_get_contents(SYSTEM_ROOT.'template/email/email.html'));
		$emailbody=str_replace('{$site_name}',$site_name,$emailbody);
		$emailbody=str_replace('{$site_url}',$site_url,$emailbody);
		$emailbody=str_replace('{$username}',$minfo['username'],$emailbody);
		$emailbody=str_replace('{$email}',$minfo['email'],$emailbody);
		$emailbody=str_replace('{$desc}',$desc,$emailbody);
		$emailbody=str_replace('{$url}',$LA['siteurl'].'member/index.php?file=account&action=certificate',$emailbody);
		require_once SYSTEM_ROOT.'include/email.class.php';
		$emailobj=new email();
		$emailobj->set($LA['mail_server'], $LA['mail_port'], $LA['mail_user'], $LA['mail_pwd'], $LA['mail_type']);
		$emailobj->send($minfo['email'], $LA['sitename'].'- ֤', $emailbody, $LA['mail_user']);
		return true;
	}

	function setcertificateauth($status,$userid)
	{
		global $settings,$_siteid,$LA,$payobj,$siteidobj;
		$minfo=$this->get($userid);

		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$userid=intval($userid);
		$status=intval($status);
		if(($status && $this->iscertificate_auth($userid)) || (!$status && !$this->iscertificate_auth($userid)))
		{
			return false;
		}

		if($status)
		{
			if($status>0)
			{
				$this->db->update($this->auth_table,array('iscertificate'=>1),'userid='.$userid);
				if($minfo['modelid']==1)
				{
					$this->db->update($this->m_person,array('point'=>intval($minfo['point']+$settings['certificateauthpoint'])),'id='.$userid);
				}
				else
				{
					$this->db->update($this->m_company,array('point'=>intval($minfo['point']+$settings['certificateauthpoint'])),'id='.$userid);
				}

				$_point=intval($settings['certificateauthpoint']);

				if($_point)
				{
					$log=array();
					$log['userid']=$userid;
					$log['inputtime']=TIME;
					$log['ichange']=$_point;
					$log['desc']='ûͨӪҵִ֤';
					$log['current']=intval($minfo['point']+$settings['certificateauthpoint']);
					$log['type']='point';
					$log['siteid']=$_SESSION['siteid'];
					$payobj->set_cashlog($userid,$log);
				}
			}
			else
			{
				$this->db->update($this->auth_table,array('iscertificate'=>0,'certificate'=>'','companyname'=>'','certno'=>''),'userid='.$userid);
			}
		}
		else
		{
			$this->db->update($this->auth_table,array('iscertificate'=>0,'certificate'=>'','companyname'=>'','certno'=>''),'userid='.$userid);

			if($minfo['modelid']==1)
			{
				$this->db->update($this->m_person,array('point'=>max(0,intval($minfo['point']-$settings['certificateauthpoint']))),'id='.$userid);
			}
			else
			{
				$this->db->update($this->m_company,array('point'=>max(0,intval($minfo['point']-$settings['certificateauthpoint']))),'id='.$userid);
			}

			$_point=intval($settings['certificateauthpoint']);

			if($_point)
			{
				$log=array();
				$log['userid']=$userid;
				$log['inputtime']=TIME;
				$log['ichange']='-'.$_point;
				$log['desc']='ûȡӪҵִ֤';
				$log['current']=max(0,intval($minfo['point']-$settings['certificateauthpoint']));
				$log['type']='point';
				$log['siteid']=$_SESSION['siteid'];
				$payobj->set_cashlog($userid,$log);
			}
		}
		
		$site_name=$LA['sitename'];
		$site_url=$LA['siteurl'];
		$desc='ύӪҵִ֤'.($status>0?'':'δ').'̨ͨˡ<br />ͨע鿴ϸϢ<br />';
		$username=userinfo($_userid,'username');

		$emailbody=stripslashes(file_get_contents(SYSTEM_ROOT.'template/email/email.html'));
		$emailbody=str_replace('{$site_name}',$site_name,$emailbody);
		$emailbody=str_replace('{$site_url}',$site_url,$emailbody);
		$emailbody=str_replace('{$username}',$minfo['username'],$emailbody);
		$emailbody=str_replace('{$email}',$minfo['email'],$emailbody);
		$emailbody=str_replace('{$desc}',$desc,$emailbody);
		$emailbody=str_replace('{$url}',$LA['siteurl'].'member/index.php?file=account&action=certificate',$emailbody);
		require_once SYSTEM_ROOT.'include/email.class.php';
		$emailobj=new email();
		$emailobj->set($LA['mail_server'], $LA['mail_port'], $LA['mail_user'], $LA['mail_pwd'], $LA['mail_type']);
		$emailobj->send($minfo['email'], $LA['sitename'].'- Ӫҵִ֤', $emailbody, $LA['mail_user']);
		return true;
	}

	function un_auth_count($type='email')
	{
		global $_siteid;
		if($_siteid)
		{
			$sql="SELECT COUNT(*) AS count FROM `$this->auth_table` WHERE `$this->auth_table`.`siteid`=".$_siteid." AND `$this->auth_table`.`".$type."`!='' AND `$this->auth_table`.`is".$type."`=0";
		}
		else
		{
			$sql="SELECT COUNT(*) AS count FROM `$this->auth_table` WHERE `$this->auth_table`.`is".$type."`=0 AND `$this->auth_table`.`".$type."`!=''";
		}

		return get_cache_counts($sql);
	}

	/**ǩ**/
	function is_signined($userid)
	{
		$userid=intval($userid);
		return $this->db->fetch_one("SELECT * FROM `$this->signin_table` WHERE `$this->signin_table`.`userid`=$userid AND `$this->signin_table`.`datetime`='".strtotime(date('Ymd',TIME))."'");
	}

	function signin_count($userid)
	{
		$userid=intval($userid);
		$starttime=strtotime(date('Ym01',TIME));
		$endtime=strtotime(date('Ymd',TIME+24*3600));
		$sql="SELECT COUNT(*) AS count FROM `$this->signin_table` WHERE `$this->signin_table`.`userid`=$userid AND `$this->signin_table`.`datetime`>=".$starttime." AND `$this->signin_table`.`datetime`<=".$endtime."";

		$r=$this->db->fetch_one($sql);
		return $r['count'];
	}

	function signin($userid)
	{
		global $settings,$payobj;
		
		$userid=intval($userid);

		if($this->is_signined($userid))
		{
			return false;
		}	
		$this->db->insert($this->signin_table,array('userid'=>intval($userid),'datetime'=>strtotime(date('Ymd',TIME))));
		
		$minfo=$this->get($userid);
		if($minfo['modelid']==1)
		{
			$this->db->update($this->m_person,array('point'=>intval($minfo['point']+$settings['signinpoint'])),'id='.$userid);
		}
		else
		{
			$this->db->update($this->m_company,array('point'=>intval($minfo['point']+$settings['signinpoint'])),'id='.$userid);
		}

		$_point=intval($settings['signinpoint']);

		if($_point)
		{
			$log=array();
			$log['userid']=$userid;
			$log['inputtime']=TIME;
			$log['ichange']=$_point;
			$log['desc']='ûÿǩ';
			$log['current']=intval($minfo['point']+$settings['signinpoint']);
			$log['type']='point';
			$log['siteid']=$_SESSION['siteid'];
			$payobj->set_cashlog($userid,$log);
		}
		return $settings['signinpoint'];
	}

	/*** **/

	function invitecodelog($receiveemail,$status,$starttime,$endtime)
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$status!=-1?' AND status ='.intval($status):'';
		$where.=$receiveemail?' AND receiveemail=\''.trim($receiveemail).'\'':'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=10;
		$result=$datalist->getlist($this->invitecode_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function invitecode_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$iinfo=$this->getinvitecodebyid($id);
		if(!$iinfo || ($_siteid && !in_array($iinfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		return $this->db->mysql_delete($this->invitecode_table,intval($id));
	}

	function getinvitecodebyid($id)
	{
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->invitecode_table` WHERE `$this->invitecode_table`.`id`=$id");
	}

	function createinvitecode($receiveemail='',$sn='')
	{
		$info=array();
		$info['invitecode']=la_md5(TIME.mt_rand(1,9999999));
		$info['inputtime']=TIME;
		$info['receiveemail']=$receiveemail;
		$info['sn']=$sn;
		$info['siteid']=$_SESSION['siteid'];
		$this->db->insert($this->invitecode_table,$info,true);

		return $info['invitecode'];
	}

	function getinvitecode($invitecode='')
	{
		return $this->db->fetch_one("SELECT * FROM `$this->invitecode_table` WHERE `$this->invitecode_table`.`invitecode`='".preg_replace('/[^a-z0-9]/i','',$invitecode)."'");
	}

	function checkinvitecode($invitecode='')
	{
		global $MEM;
		$r=$this->getinvitecode($invitecode);
		return ($r && $r['status']==0 && (TIME-$r['inputtime'])<=$MEM['settings']['invitecode_expire']*24*3600)?true:false;
	}

	function setinvitecode($invitecode='',$info=array())
	{
		return $this->db->update($this->invitecode_table,$info,"invitecode='".preg_replace('/[^a-z0-9]/i','',$invitecode)."'");
	}

	function logout()
	{
		$_SESSION['refer']='';
		set_cookie('auth', '');
		return true;
	}
}
?>
